<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <!--
   <xsl:output
      doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
      doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
      method="xml"
      encoding="UTF-8"
      omit-xml-declaration="no"
      indent="yes" />
      -->

   <!--***************************************************************************
   //
   //    Copyright (C) 2004, Agilent Technologies. All rights reserved.
   // Contributor: Design Validation Division
   //     Product: Infiniium Scope Family
   //
   //    $RCSfile: report.xsl $
   //
   // Description:
   //
   //**************************************************************************-->

   <!--<xsl:template match="ComplianceReporter">
   </xsl:template>-->

   <!--
   <xsl:template match="ComplianceReporter/MarginReporting/WarningAtMargin">
       <xsl:variable name='WarningAtMargin' select='.'/>
   </xsl:template>

   <xsl:template match="ComplianceReporter/MarginReporting/CriticalAtMargin">
       <xsl:variable name='CriticalAtMargin' select='.'/>
   </xsl:template>

   <xsl:template match="ComplianceReporter/MarginReporting/MarginReporting">
       <xsl:variable name='MarginReporting' select='.'/>
       MarginReporting: <xsl:value-of select="."/>
   </xsl:template>
   -->


   <!-- This template formats a table row for a header item -->
   <xsl:template match="ComplianceReporter/ReportHeader/HeaderGroups/HeaderGroup">
      <tr >
         <td style="text-align:center;font-weight:bold;background-color:#7AE5F8">
            <xsl:attribute name="colspan">2</xsl:attribute>
            <xsl:value-of select="GroupName"/>
         </td>
      </tr>
      <xsl:apply-templates select="HeaderItems"/>
   </xsl:template>

   <xsl:template match="HeaderItems/HeaderItem">
      <tr>
         <td style="text-align:left;background-color:#AAA;">
            <b>
               <xsl:value-of select="Name"/>
            </b>
         </td>
         <td>
            <xsl:value-of select="Value"/>
         </td>

      </tr>
   </xsl:template>

   <xsl:variable name='UseHyperlinksInSummaryTable' select='ComplianceReporter/UseHyperlinksInSummaryTable'/>

   <xsl:template name="TestSummaryRow" match="CompliancReporter/TestResults/Result">
      <!-- show the pass or fail image appropriately -->
      <TD class="passfail">
         <xsl:element name='img'>
            <xsl:attribute name='src'>
               <xsl:choose>
                  <!-- Choose the image to go in column 0 of the test summary table -->
                  <xsl:when test="InfoOnly='true'">
                     report_files/info.bmp
                  </xsl:when>
                  <xsl:when test="TrialSummary/Pass='true'">
                    report_files/pass.gif
                  </xsl:when>
                  <xsl:otherwise>
                    report_files/fail.gif
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:attribute>
         </xsl:element>
      </TD>
      <TD >
         <xsl:value-of select="TrialSummary/NumFailedTrials"/>
      </TD>
      <TD >
         <xsl:value-of select="TrialSummary/NumTrials"/>
      </TD>
      <!-- Print Test Name -->
      <xsl:variable name='IsAddIn' select='TestDescription/AddIn'/>
      <xsl:choose>
      <xsl:when test="$UseHyperlinksInSummaryTable='true'">
        <TD >
           <!-- Make a hyperlink to the test results for this test -->
           <xsl:element name='a'>
              <xsl:attribute name='href'>#Test<xsl:value-of select="TestDescription/TestID"/></xsl:attribute>
              <xsl:choose>
                 <xsl:when test="$IsAddIn='true'">
                    User Defined <xsl:value-of select="TestDescription/TestName"/>
                 </xsl:when>
                 <xsl:otherwise>
                    <xsl:value-of select="TestDescription/TestName"/>
                 </xsl:otherwise>
              </xsl:choose>


           </xsl:element>
        </TD>
      </xsl:when>
      <xsl:otherwise>
        <TD >
           <xsl:value-of select="TestDescription/TestName"/>
        </TD>
      </xsl:otherwise>
      </xsl:choose>
      

      
      <TD >
         <xsl:value-of select="TrialSummary/SummaryActualValue"/>
      </TD>
      

      <xsl:if test="$MarginReporting='true'">
         <TD >
            <xsl:choose>
               <xsl:when test="(not(string(TrialSummary/Margin)))">N/A
               </xsl:when>

               <!-- Prevent info-only tests from showing a margin value in the test summary table-->
               <xsl:when test="InfoOnly='true'">
               </xsl:when>

               <xsl:when test="(TrialSummary/DoubleMargin >= $WarningAtPercent)">
                  <xsl:attribute name="class">good</xsl:attribute>
                  <xsl:value-of select="TrialSummary/Margin"/>
%
               </xsl:when>

               <xsl:when test="(TrialSummary/DoubleMargin >= $CriticalAtPercent)">
                  <xsl:attribute name="class">warning</xsl:attribute>
                  <xsl:value-of select="TrialSummary/Margin"/>
%
               </xsl:when>

               <xsl:otherwise>
                  <xsl:attribute name="class">critical</xsl:attribute>
                  <xsl:value-of select="TrialSummary/Margin"/>
%
               </xsl:otherwise>
            </xsl:choose>
         </TD>
      </xsl:if>
      <TD >
         <xsl:value-of select="TestDescription/ShortTestDescriptor"/>
      </TD>
   </xsl:template>

   <!-- This template outputs a summary table row for each result -->
   <xsl:template match="ComplianceReporter/TestResults/Result" mode="ResultsSummary">
      <!--<DIV class="summaryrow">-->
      <xsl:element name='a'>
         <xsl:attribute name='name'>SummaryTest<xsl:value-of select="TestDescription/TestID"/></xsl:attribute>
      </xsl:element>
      <TR >
         <xsl:choose>
            <xsl:when test="(position() mod 2 = 1)">
               <xsl:attribute name="class">odd</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
               <xsl:attribute name="class">even</xsl:attribute>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:call-template name="TestSummaryRow"/>
      </TR>
   </xsl:template>

   <xsl:template name="Data" match="ExtraData/ExtraDataItem">
      <span class="FieldValueBlock">
         <span class="Field">
            <b>
               <xsl:value-of select="@Name"/>
            </b>
         </span>


         <!-- this is a normal value, display it -->
         <span class="Value">
            <xsl:value-of select="@Value"/>
         </span>
      </span>
   </xsl:template>


   <xsl:template match="TrialSummaryTable/Rows/Row/Columns/Column">
      <xsl:param name="odd"/>
      <xsl:param name="lastTrial"/>

      <xsl:if test="position()!=2">
         <TD>
            <!--STYLE="padding-left:.25em;padding-right:.25em">-->
            <xsl:choose>
               <xsl:when test="$odd and $lastTrial">
                  <xsl:attribute name="class">odd_underline</xsl:attribute>
               </xsl:when>
               <xsl:when test="$odd">
                  <xsl:attribute name="class">odd</xsl:attribute>
               </xsl:when>
               <xsl:when test="not($odd) and $lastTrial">
                  <xsl:attribute name="class">even_underline</xsl:attribute>
               </xsl:when>
               <xsl:when test="not($odd)">
                  <xsl:attribute name="class">even</xsl:attribute>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:attribute name="class">even</xsl:attribute>
               </xsl:otherwise>
            </xsl:choose>

            <!--<xsl:apply-templates/>-->
            <xsl:choose>
               <xsl:when test="(not(string(Name)))">N/A
               </xsl:when>
               <xsl:otherwise>
                  <xsl:apply-templates/>
               </xsl:otherwise>
            </xsl:choose>
         </TD>
      </xsl:if>
   </xsl:template>

   <xsl:template match="TrialSummaryTable/Rows/Row/Columns/Column[../../@Type='SUMMARY_ROW']">
      <xsl:param name="odd"/>
      <xsl:param name="lastTrial"/>


      <xsl:if test="position()!=2">
         <TD class="TrialSummaryRow">
            <xsl:apply-templates/>
         </TD>
      </xsl:if>
   </xsl:template>

   <xsl:template match="TrialSummaryTable/Rows/Row/Columns/Column[@MarkupType='WARNING']">
      <xsl:param name="odd"/>
      <xsl:param name="lastTrial"/>

      <xsl:if test="position()!=2">
         <TD class="warning">
            <xsl:apply-templates/>
         </TD>
      </xsl:if>
   </xsl:template>
   <xsl:template match="TrialSummaryTable/Rows/Row/Columns/Column[@MarkupType='FAIL']">
      <xsl:param name="odd"/>
      <xsl:param name="lastTrial"/>

      <xsl:if test="position()!=2">
         <TD class="critical">
            <xsl:apply-templates/>
         </TD>
      </xsl:if>
   </xsl:template>

   <xsl:template match="TrialSummaryTable/Header/Column">
      <xsl:if test="position()!=2">
         <TD valign="bottom" style="background-color:#AAA;font-weight:bold;border-top:thin solid black;border-bottom:thin solid black;padding-left:.25em;padding-right:.25em">
            <xsl:apply-templates/>
         </TD>
      </xsl:if>
   </xsl:template>

   <xsl:template match="TrialSummaryTable/Header">
      <tr>
            <xsl:choose>
               <xsl:when test="../../../InfoOnly='false'">
                  <TD STYLE="background-color:#AAA;font-weight:bold;border-bottom:thin solid black;border-top:thin solid black; padding-left:.25em;padding-right:.25em">
                     Pass
                  </TD>
               </xsl:when>
            </xsl:choose>
         <xsl:apply-templates/>
      </tr>
   </xsl:template>

   <xsl:template match="TrialSummaryTable/Rows/Row/Columns">
      <xsl:param name="odd"/>
      <xsl:param name="lastTrial"/>
      <xsl:apply-templates>
         <xsl:with-param name="lastTrial" select="$lastTrial"/>
         <xsl:with-param name="odd" select="$odd"/>
      </xsl:apply-templates>
   </xsl:template>

   <xsl:template match="TrialSummaryTable/Rows/Row">
      <tr>
         <xsl:variable name='LastTrial' select="position()=(count(../../../../TrialResults/Reference))"/>
         <xsl:variable name='Odd' select="position() mod 2 = 1"/>
         <xsl:choose>
            <xsl:when test="./@Type='SUMMARY_ROW'">
               <xsl:attribute name="class">TrialSummaryRow</xsl:attribute>
            </xsl:when>
            <xsl:when test="$Odd">
               <xsl:attribute name="class">odd</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
               <xsl:attribute name="class">even</xsl:attribute>
            </xsl:otherwise>
         </xsl:choose>

         <xsl:choose>
            <xsl:when test="../../../../InfoOnly='false'">
               <TD>
                  <xsl:choose>
                     <xsl:when test="./@Type='SUMMARY_ROW'">
                        <xsl:attribute name="class">TrialSummaryRow</xsl:attribute>
                     </xsl:when>
                     <xsl:when test="$Odd and $LastTrial">
                        <xsl:attribute name="class">odd_underline</xsl:attribute>
                     </xsl:when>
                     <xsl:when test="$Odd">
                        <xsl:attribute name="class">odd</xsl:attribute>
                     </xsl:when>
                     <xsl:when test="not($Odd) and $LastTrial">
                        <xsl:attribute name="class">even_underline</xsl:attribute>
                     </xsl:when>
                     <xsl:when test="not($Odd)">
                        <xsl:attribute name="class">even</xsl:attribute>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:attribute name="class">even</xsl:attribute>
                     </xsl:otherwise>
                  </xsl:choose>
                  <xsl:choose>
                     <xsl:when test="Columns/Column[2]/Name='PASS'">
                        <img SRC="report_files/pass.gif"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:choose>
                           <xsl:when test="Columns/Column[2]/Name='FAIL'">
                              <img SRC="report_files/fail.gif"/>
                           </xsl:when>
                           <xsl:otherwise>
                              <!-- Nothing -->
                           </xsl:otherwise>
                        </xsl:choose>
                     </xsl:otherwise>
                  </xsl:choose>
               </TD>
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
         </xsl:choose>
         
         <xsl:apply-templates>
            <xsl:with-param name="lastTrial" select="position()=(count(../../../../TrialResults/Reference))"/>
            <xsl:with-param name="odd" select="position() mod 2 = 1"/>
         </xsl:apply-templates>

      </tr>
   </xsl:template>

   <xsl:template match="TrialSummaryTable/Rows">
      <xsl:apply-templates/>
   </xsl:template>

   <xsl:template match="TrialSummaryTable/Name">
   </xsl:template>

   <xsl:template match="TrialSummaryTable/Rows/Row[../../@Type='IMAGE_SUMMARY']">
      <!-- anchor so we can link to this specific test from summary-->
      <!-- DONT BREAK THIS LINE UP! -->
      <!--<xsl:element name='a'><xsl:attribute name='name'>Test<xsl:value-of select="../../Header/ID"/>_<xsl:value-of select="Columns/Column[1]/Name"/></xsl:attribute></xsl:element>-->
      <!--<SPAN class="NewFieldValueBlock">-->
      <!--<DIV class="NewFieldValueBlock">-->
      <!--<DIV STYLE="width:110;float:left;widow:4;orphans:4;border:thin black solid;margin:0.5em">-->
      <span style="ClearIfVerbose"/>
      <span class="ImageTable">
         <div class="ImageTableRow">
           <xsl:choose>
               <xsl:when test="UserTable != 0">
                 <span>
                   <TABLE class="OverallSummaryTable" BORDER="thin" cellspacing="0pt">
                   <xsl:apply-templates select="UserTable"/>
                 </TABLE>
               </span>
             </xsl:when>
             <xsl:otherwise>
                <div class="ImageCaption">
                 <xsl:value-of select="Columns/Column[1]/Name"/>
               </div>
               <span class="ImageTableCell">
                 <IMG>
                   <xsl:attribute name='class'>scopegrat</xsl:attribute>
                   <xsl:attribute name='src'>
                     <xsl:value-of select="Columns/Column[2]/Name"/>
                   </xsl:attribute>
                 </IMG>
               </span>
             </xsl:otherwise>
           </xsl:choose>

         </div>
      </span>

      <!--</SPAN>-->

      <!--
        <TABLE STYLE="font-size:10pt" BORDER="thin" cellspacing="0pt">
        <tr>
        <td>
        <xsl:value-of select="Columns/Column[1]/Name"/>
        </td>
        <td>
            <IMG width="400" height="300">
                <xsl:attribute name='src'>
        <xsl:value-of select="Columns/Column[2]/Name"/>
                </xsl:attribute>
            </IMG>
        </td>
        </tr>
        </TABLE>
        -->
   </xsl:template>

  <!-- This template outputs the header row of a UserTable -->
  <xsl:template match="UserTable/Header">
    <TR>
      <xsl:apply-templates select="Column"/>
    </TR>
  </xsl:template>

  <!-- This template outputs one cell of the header row of a UserTable -->
  <xsl:template match="UserTable/Header/Column">
      <TD style="background-color:#AAA">
        <B>
          <xsl:value-of select="Name"/>
        </B>
      </TD>
  </xsl:template>

  <!-- This template outputs a value row of a UserTable -->
  <xsl:template match="UserTable/Rows/Row">
    <TR>
      <xsl:apply-templates select="Columns/Column"/>
    </TR>
  </xsl:template>

  <!-- This template outputs one cell of a value row of a UserTable -->
  <xsl:template match="UserTable/Rows/Row/Columns/Column">
    <TD>
      <xsl:value-of select="Name"/>
    </TD>
  </xsl:template>

  <xsl:template match="TrialSummaryTable[@Type='IMAGE_SUMMARY']">
      <!--<DIV STYLE="margin-left:1em;padding-left:1em;border:thin black solid;font-weight:bold">-->
      <DIV style="clear:both;">
         <span class="TableCaption">
            <xsl:value-of select="Header/Column/Name"/>
         </span>
      </DIV>
      <xsl:apply-templates select="Rows"/>
   </xsl:template>

  <xsl:template match="TrialSummaryTable">
      <br style="clear:both"/>
      <span class="TableCaption">
         <xsl:value-of select="Name"/>
      </span>
      <!--<p>-->
      <!--<SPAN style="border:thin black solid;">-->
      <TABLE class="TrialSummaryTable" BORDER="0" cellspacing="0" CELLPADDING="2px">
         <xsl:apply-templates/>
      </TABLE>
   </xsl:template>


   <xsl:template match="Result/TrialSummaryTables">
      <xsl:apply-templates/>
   </xsl:template>

   <xsl:template match="ReportedTestTrials">
      <xsl:for-each select="TrialResults">
         <xsl:for-each select="Reference">
            <xsl:for-each select="ReportedTestTrialItems">
               <xsl:for-each select="ReportedTestTrialItem">
                  <xsl:variable name='ImagePathFile' select="ReportedTestTrials/TrialResults/Reference/ReportedTestTrialItems/ReportedTestTrialItem/ImageFile"/>

                        <xsl:call-template name="TestReference">
                           <xsl:with-param name="ResultCount">
                              <xsl:number count="Reference"/>
                           </xsl:with-param>
                        </xsl:call-template>

               </xsl:for-each>
            </xsl:for-each>
         </xsl:for-each>
      </xsl:for-each>
   </xsl:template>

   <xsl:template name="TestReference" match="ReportedTestTrials/TrialResults/Reference/ReportedTestTrialItems/ReportedTestTrialItem">

      <!-- QaInfApps.334: Include all ReportMeas values in the HTML report for the 1 trial case -->
      <!-- <xsl:choose>
         <xsl:when test="(string-length(ImageFile) != 0)">
            This result has an image
            <xsl:choose>
               <xsl:when test="(code ='true')">
                   Code plus image 
                  <xsl:call-template name="ReferenceFigureAndCode"/>
               </xsl:when>

               <xsl:otherwise>
                   Image with Caption (no code) 
                  <xsl:call-template name="ReferenceFigureAndCaption"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:when> -->
         
         <!-- <xsl:otherwise> -->
            <!-- No Image in this reference item -->
      <xsl:choose>
         <xsl:when test="(string-length(ActualValue) != 0)">
            <xsl:choose>
               <xsl:when test="(code ='true')">
                  <!-- Code without image -->
                  <xsl:call-template name="ReferenceFieldWithCode"/>
               </xsl:when>

               <xsl:otherwise>
                  <!-- No Image, No Code its a FieldValueBox -->
                  <xsl:call-template name="ReferenceFieldValue"/>
               </xsl:otherwise>

            </xsl:choose>
         </xsl:when>
      </xsl:choose>

   </xsl:template>


   <!-- This templates outputs detailed information about each result -->
   <xsl:template match="ComplianceReporter/TestResults/Result" mode="ResultsDetail">
      <xsl:element name='a'>
         <!-- anchor so we can link to this specific test from summary and from 'Prev' navigation button-->
         <!-- DONT BREAK THIS LINE UP! -->
         <xsl:attribute name='name'>Test<xsl:value-of select="TestDescription/TestID"/></xsl:attribute>
      </xsl:element>

      <xsl:choose>
         <xsl:when test="$UseHyperlinksInSummaryTable='true'">
            <!-- Make "Next" navigation hyperlink -->
            <span class='Navigation'>
               <xsl:element name='a'>
                  <xsl:attribute name='href'>
                     #EndTest<xsl:value-of select="TestDescription/TestID"/>
                  </xsl:attribute>
                  Next
               </xsl:element>
            </span>
         </xsl:when>
      </xsl:choose>


      <xsl:variable name='NumTrials' select='TrialSummary/NumTrials'/>
      <xsl:variable name='NumImages' select='count(OverallReferences/Reference[string-length(ImageFile)!=0])'/>
      <!-- Test Name in black-->
      <br>
         <xsl:choose>
            <xsl:when test="not(position()=1) and ($NumTrials>1 or $NumImages>0)">
               <xsl:attribute name="style">page-break-before:always;</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
         </xsl:choose>
      </br>
      <DIV class="TESTHEADER" >

         <!--STYLE="border-width:1pt;border-color:black;border-style:solid;background-color:black; color:white; padding:4px"-->
         <!-- show the pass or fail image appropriately -->
         <SPAN class="passfail">
            <xsl:element name='img'>
               <xsl:attribute name='src'>
                  <xsl:choose>
                     <!-- Select the image to place in the big black title bar of this tests's detail section -->
                     <xsl:when test="InfoOnly='true'">report_files/info.bmp</xsl:when>
                     <xsl:when test="TrialSummary/Pass='true'">report_files/pass.gif</xsl:when>
                     <xsl:otherwise>report_files/fail.gif</xsl:otherwise>
                  </xsl:choose>
               </xsl:attribute>
            </xsl:element>
         </SPAN>         
         
         <SPAN class="testname">
            <xsl:variable name='IsAddIn' select='TestDescription/AddIn'/>
            <xsl:choose>
               <xsl:when test="$IsAddIn='true'">
                  User Defined <xsl:value-of select="TestDescription/TestName"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="TestDescription/TestName"/>
               </xsl:otherwise>
            </xsl:choose>
         </SPAN>

         <!--<DIV style="padding:0px;text-align:right">-->
         <!-- Right Justified reference in black-->
         <SPAN class="SpecReference">
                    Reference:
            <xsl:value-of select="TestDescription/TestReference"/>
         </SPAN>
      </DIV>



      <!-- Test Description -->
      <SPAN class="TestDescription">
         <SPAN class="TestSummary">
            <span style="valign:top;padding-left:2pt;padding-right:2pt;background-color=black;color:white;">
                      Test Summary:
            </span>
            <xsl:choose>
               <!-- The backlit word to write in the "Test Summary" field in the titlebar of each test's detail section -->
                  <xsl:when test="InfoOnly='true'">
                     <span class="Info">Info</span>
                  </xsl:when>
                  <xsl:when test="TrialSummary/Pass='true'">
                  <span class="Pass" >Pass</span>
               </xsl:when>
               <xsl:otherwise>
                  <span class="Fail">FAIL</span>
               </xsl:otherwise>
            </xsl:choose>
         </SPAN>
         <span>
            <!--<span style="margin-left:4px;valign:top;flow:left;padding-top:0px;padding-left:4px;padding-right:4px;background-color:#333;color:white">-->
            <span style="margin-left:4px;valign:top;flow:left;padding-top:0px;padding-left:4px;padding-right:4px;text-decoration:underline;border-right: 1pt black solid">
                     Test Description:
            </span>
            <span style="text-indent:2em;margin-left:6px;margin-right:4px">
               <nbsp/>
               <xsl:value-of select="TestDescription/TestDescription"/>
            </span>
         </span>
         <br style="clear:both"/>
         <SPAN class="FieldValueBlock">
            <span class="Field">Pass Limits:</span>
            <span class="Value">
               <xsl:value-of select="TestDescription/TestDescriptor"/>
            </span>
         </SPAN>

         <!-- Parameter Tested -->
         <!--<DIV class="FieldValueBlock">-->
         <SPAN class="FieldValueBlock">
            <span class="Field">
                   <xsl:value-of select="TrialSummary/SummaryActualDescriptor"/>
            </span>
            <span class="Value">
               <xsl:value-of select="TrialSummary/SummaryActualValue"/>
            </span>
         </SPAN>
         <xsl:choose>
            <xsl:when test="$NumTrials>1">
               <SPAN class="FieldValueBlock">
                  <span class="Field">
                     # Trials Run:
                  </span>
                  <span class="Value">
                     <xsl:value-of select="TrialSummary/NumTrials"/>
                  </span>
               </SPAN>
               <SPAN class="FieldValueBlock">
                  <span class="Field">
                    <xsl:value-of select="$StoreMode"/> Trial:
                  </span>
                  <span class="Value">
                     Trial <xsl:value-of select="TrialSummary/WorstTrialNumOneBased"/>
                  </span>
               </SPAN>                       
            </xsl:when>
         </xsl:choose>         
      </SPAN>


      <DIV style="clear:both"/>

      <!--
      <SPAN class="ClearIfCompact">
      </SPAN>
      -->

      <xsl:if test="1">
         <DIV class="ReferenceDivider">
            <span class="ReferenceDividerSpan">Result Details:</span>
         </DIV>

         <!-- Only display trial summary table for tests containing more than 1 trial -->
         <xsl:choose>
            <xsl:when test="$NumTrials>1">
               <xsl:apply-templates select="TrialSummaryTables/TrialSummaryTable[@Type='TRIAL_SUMMARY']"/>
            </xsl:when>
            <xsl:otherwise>
               <span style="font-size:10pt">
                  <b>Result Details</b>
                  <br/>
               </span>
               <xsl:apply-templates select="ReportedTestTrials"/>
               <br/>
            </xsl:otherwise>
         </xsl:choose>         

         <!-- Always display trial images -->
         <xsl:apply-templates select="TrialSummaryTables/TrialSummaryTable[@Type='IMAGE_SUMMARY']"/>

</xsl:if>

      <xsl:choose>
         <xsl:when test="$UseHyperlinksInSummaryTable='true'">
            <!-- Make "Top" navigation hyperlink -->
            <br/>
            <span class='Navigation'>
               <xsl:element name='a'>
                  <xsl:attribute name='href'>#OverallSummaryTable</xsl:attribute>
                  Top
               </xsl:element>
            </span>
            <!-- Make "Previous" navigation hyperlink -->
            <span class='Navigation'>
               <xsl:element name='a'>
                  <xsl:attribute name='href'>
                     #Test<xsl:value-of select="TestDescription/TestID"/>
                  </xsl:attribute>
                  Previous
               </xsl:element>
            </span>
         </xsl:when>
      </xsl:choose>

      <xsl:element name='a'>
         <!-- anchor so we can link to the end of this section for the 'Next' navigation button-->
         <!-- DONT BREAK THIS LINE UP! -->
         <xsl:attribute name='name'>EndTest<xsl:value-of select="TestDescription/TestID"/></xsl:attribute>
      </xsl:element>

   </xsl:template>

  <xsl:template name="HtmlHeader">
      <head>
         <link id="ss1" href="report_files/Compact.css" rel="stylesheet" type="text/css" />
         <link id="sscommon" href="report_files/common.css" rel="stylesheet" type="text/css" />
         <!-- Enable hiding navigation buttons in printed report-->
         <link rel="stylesheet" href="report_files/print.css" media="print" />
         <!--         <script language="Javascript" type="text/javascript" src="report_files/ChangeStyleSheet.js"></script>-->
      </head>
   </xsl:template>

   <xsl:template name="ReferenceFieldWithCode">
      <span class="FieldValueBlock">
         <!-- User reported Parameter-->
         <span>
            <xsl:attribute name='class'>Field</xsl:attribute>
            <xsl:value-of select="ActualDescriptor"/>
         </span>

         <span style="font-size:8pt; margin-left:20px">
            <pre>
               <xsl:value-of select="ActualValue"/>
            </pre>
         </span>

         <b>
            <center>
               <xsl:value-of select="Name"/>
            </center>
         </b>
      </span>
   </xsl:template>
   <xsl:template name="ReferenceFigureAndCode">
      <p>
         <span class="FieldValueBlock">
            <!-- User reported Parameter-->
            <span>
               <xsl:attribute name='class'>Field</xsl:attribute>
               <xsl:value-of select="ActualDescriptor"/>
            </span>

            <span style="font-size:8pt; margin-left:20px">
               <pre>
                  <xsl:value-of select="ActualValue"/>
               </pre>
            </span>

            <b>
               <center>
                  <xsl:value-of select="Name"/>
               </center>
            </b>
            <xsl:call-template name="ReferenceFigure"/>
         </span>
      </p>
   </xsl:template>

   <xsl:template name="ReferenceFigure">
      <!--<DIV STYLE="background-color:#FFF;margin-bottom:4px;margin-left:4px;clear:both">-->
      <span style="clear:both;background-color:#F00">
         <xsl:element name='img'>

            <!--<xsl:attribute name="id">img<xsl:number count="/ComplianceReporter/TestResults/Result" format="1_" /><xsl:number count="/ComplianceReporter/TestResults/Result/References/Reference" format="1" />')</xsl:attribute>-->
            <!--<xsl:attribute name="id">img<xsl:number count="Result" format="1_" /><xsl:number count="References/Reference" format="1" />')</xsl:attribute>-->
            <!-- DON'T BREAK THIS LINE UP! -->
            <xsl:attribute name="id">img
               <xsl:number count="Result" format="1_"/>
               <xsl:number count="Result/OverallReferences/Reference" format="1"/>
            </xsl:attribute>


            <!--<xsl:attribute name='width'>512</xsl:attribute>
            <xsl:attribute name='height'>264</xsl:attribute>-->
            <!--<xsl:attribute name='align'>left</xsl:attribute>
            <xsl:attribute name='valign'>top</xsl:attribute>-->
            <xsl:attribute name='class'>scopegrat</xsl:attribute>
            <xsl:attribute name='src'>
               <xsl:value-of select='ImageFile'/>
            </xsl:attribute>
         </xsl:element>
      </span>
      <!--</DIV>-->
   </xsl:template>

   <xsl:template name="ReferenceFigureAndCaption">

      <!-- reference image -->
      <span class="NewFieldValueBlock">
         <!--<DIV class="NewFieldValueBlock">-->

         <p>
            <span>
               <xsl:attribute name='class'>FigureCaption</xsl:attribute>
             Figure:
               <xsl:value-of select="ActualDescriptor"/>
            </span>
            <!--
            <span class="zoom-tablecell">
               <a>
                  DON'T BREAK THIS LINE UP!
                  <xsl:attribute name="href">javascript:HighlightMaskHits(1.0, 'img
                     <xsl:number count="Result" format="1_" />
                     <xsl:number count="Result/References/Reference" format="1" />
   ')</xsl:attribute>
   Normal/Show Failures</a>
            </span>
            <span class="zoom-tablecell">
               <a>
                  <xsl:attribute name="href">javascript:ZoomImage(1.0, 'img<xsl:number count="Result" format="1_" /><xsl:number count="Result/References/Reference" format="1" />')</xsl:attribute>
                   ZoomIn/Out</a>
            </span>
            -->
            <!--
            <span class="zoom-tablecell">
                <a> <xsl:attribute name="href">javascript:HighlightMaskHits(1.0, 'img<xsl:number count="Result" format="1_" /><xsl:number count="Result/References/Reference" format="1" />')</xsl:attribute>Normal/Show Failures</a>
            </span>
            <span class="zoom-tablecell">
                <a> <xsl:attribute name="href">javascript:ZoomImage(1.0, 'img<xsl:number count="Result" format="1_" /><xsl:number count="Result/References/Reference" format="1" />')</xsl:attribute>ZoomIn/Out</a>
            </span>
            -->
            <b>
               <center>
                  <xsl:value-of select="Name"/>
               </center>
            </b>

            <xsl:call-template name="ReferenceFigure"/>
         </p>
      </span>
   </xsl:template>

   <!-- This is just a simple field/value pair -->
   <xsl:template name="ReferenceFieldValue">
     <xsl:choose>
       <xsl:when test="not(ImageOnly) or ImageOnly='false'">
         <span class="FieldValueBlock">
           <span class="Field">
             <b>
               <xsl:value-of select="ActualDescriptor"/>
             </b>
           </span>

           <span class="Value">
             <xsl:value-of select="ActualValue"/>
           </span>
         </span>
       </xsl:when>
     </xsl:choose>
   </xsl:template>

   <!-- Generate the header of the report -->
   <xsl:template name="ReportHeader">

      <!-- Agilent Image, Report Header -->
      <DIV class="row">
         <span class="left">
            <img valign="top" src="report_files/agilent.gif"/>
         </span>
         <xsl:variable name='AppNameBase' select='ComplianceReporter/AppNameBase'/>
         <center>
            <DIV style="clear:both;line-height:1em;font-size:18pt;font-weight:bold;color:black">
               <xsl:value-of select="$AppNameBase"/>
                Test Report
            </DIV>
         </center>
      </DIV>

      <xsl:variable name='NumFailures' select='count(ComplianceReporter/TestResults/Result/TrialSummary/Pass[normalize-space(text())="false"])'/>
      <xsl:variable name='NumTests' select='count(ComplianceReporter/TestResults/Result)'/>
      <xsl:choose>
         <xsl:when test="$NumTests = 0">

         </xsl:when>
         <xsl:otherwise>
            <br/>
            <p style="margin:0.25em">
               <center>
                  <b>Overall Result: </b>
                  <xsl:choose>
                     <xsl:when test="$NumFailures > 0">
                        <span class="Fail">FAIL</span>
                     </xsl:when>
                     <xsl:otherwise>
                        <span class="Pass">PASS</span>
                     </xsl:otherwise>
                  </xsl:choose>
               </center>
            </p>

            <!-- Report any test header fields, if there is at least one to report -->
            <xsl:variable name='NumHeaders' select='count(/ComplianceReporter/ReportHeader/HeaderGroups/HeaderGroup/HeaderItems/HeaderItem)'/>
            <xsl:if test='number($NumHeaders)>0'>
               <center>
                  <TABLE  class="TestConfigDetailsTable" BORDER="none" cellspacing="1pt">
                     <tr >
                        <td  colspan="2" style="background-color:#AAA;">
                           <b>
                              <center>Test Configuration Details</center>
                           </b>
                        </td>
                     </tr>


                     <xsl:apply-templates select="ComplianceReporter/ReportHeader"/>
                  </TABLE>
               </center>
            </xsl:if>
         </xsl:otherwise>
      </xsl:choose>

   </xsl:template>

   <xsl:variable name='WarningAtPercent' select='/ComplianceReporter/MarginReporting/WarningAtPercent'/>
   <xsl:variable name='CriticalAtPercent' select='/ComplianceReporter/MarginReporting/CriticalAtPercent'/>
   <xsl:variable name='MarginReporting' select='/ComplianceReporter/MarginReporting/MarginReporting'/>
   <xsl:variable name='StoreMode' select='/ComplianceReporter/StoreMode'/>

   <xsl:strip-space elements="*"/>
   <xsl:template match="/">
      
      <HTML>
         <xsl:comment>SkipSubstituteVars</xsl:comment>
         <!-- Generate Html Headers -->
         <xsl:call-template name="HtmlHeader"/>

         <BODY STYLE="background-color:white;font-family:Arial, helvetica, sans-serif; font-size:12pt">

            <!--<xsl:apply-templates select="ComplianceReporter/MarginReporting"/>-->

            <a name="Top"/>

            <!-- First just see how many failed -->
            <xsl:variable name='NumFailures' select='count(ComplianceReporter/TestResults/Result/TrialSummary/Pass[normalize-space(text())="false"])'/>
            <xsl:variable name='NumPass' select='count(ComplianceReporter/TestResults/Result/TrialSummary/Pass[normalize-space(text())!="false"])'/>
            <xsl:variable name='NumTests' select='count(ComplianceReporter/TestResults/Result)'/>
            <xsl:variable name='AnyTestHasMultipleTrials' select='ComplianceReporter/AnyTestHasMultipleTrials'/>
            <xsl:call-template name="ReportHeader"/>
            <xsl:choose>
               <xsl:when test="$NumTests = 0">
                  <hr/>
                  <center>
                     <h2> No results are available</h2>
                  </center>
                  No tests have been run
               </xsl:when>
               <xsl:otherwise>
                  <h2 style="page-break-before:always">Summary of Results</h2>
                  <!--Display Test Statistics overview table -->
                  <TABLE class="MarginThresholdsTable" BORDER="thin" cellspacing="0pt">
                     <TR>
                        <TD colspan="2" class="header">Test Statistics</TD>
                     </TR>
                     <TR>
                        <TD>
                           <b>Failed</b>
                        </TD>
                        <TD>
                           <xsl:choose>
                              <xsl:when test="$NumFailures > 0">
                                 <span class="Fail">
                                    <xsl:value-of select="$NumFailures"/>
                                 </span>
                              </xsl:when>
                              <xsl:otherwise>
                                 <span class="Neutral">
                                    <xsl:value-of select="$NumFailures"/>
                                 </span>
                              </xsl:otherwise>
                           </xsl:choose>
                        </TD>
                     </TR>
                     <TR>
                        <TD>
                           <b>Passed</b>
                        </TD>
                        <TD>
                           <span class="Neutral">
                              <xsl:value-of select="$NumPass"/>
                           </span>
                        </TD>
                     </TR>
                     <TR>
                        <TD>
                           <b>Total</b>
                        </TD>
                        <TD>
                           <span class="Neutral">
                              <xsl:value-of select="$NumTests"/>
                           </span>
                        </TD>
                     </TR>
                  </TABLE>
                  <xsl:if test="$MarginReporting='true'">
                     <br/>
                     <TABLE class="MarginThresholdsTable" BORDER="thin" cellspacing="0pt">
                        <TR>
                           <TD colspan="2" class="header">Margin Thresholds</TD>
                        </TR>
                        <TR>
                           <TD class="warning">Warning</TD>
                           <TD>&lt;
                              <xsl:value-of select="$WarningAtPercent"/>
%</TD>
                        </TR>
                        <TR>
                           <TD class="critical">Critical</TD>
                           <TD>&lt;
                              <xsl:value-of select="$CriticalAtPercent"/>
%</TD>
                        </TR>
                     </TABLE>
                  </xsl:if>
                  <!-- anchor so we can link to this table from the 'Top' navigation buttons-->
                  <a name="OverallSummaryTable" />
                  <br/>
                  <TABLE  class="OverallSummaryTable" BORDER="thin" cellspacing="0pt">
                     <TR>
                        <TD style="background-color:#AAA">
                           <B>Pass</B>
                        </TD>
                        <TD style="background-color:#AAA">
                           <B># Failed</B>
                        </TD>
                        <TD style="background-color:#AAA">
                           <B># Trials</B>
                        </TD>
                        <TD style="background-color:#AAA">
                           <B>Test Name</B>
                        </TD>
                        

                        <xsl:choose>
                           <xsl:when test="$AnyTestHasMultipleTrials='true'">
                              <TD style="background-color:#AAA">
                                 <B>
                                   <xsl:value-of select="$StoreMode"/> Actual</B>
                              </TD>
                              <xsl:if test="$MarginReporting='true'">
                                 <TD style="background-color:#AAA">
                                    <B>
                                      <xsl:value-of select="$StoreMode"/> Margin</B>
                                 </TD>
                              </xsl:if>
                           </xsl:when>
                           <xsl:otherwise>
                              <TD style="background-color:#AAA">
                                 <B>Actual Value</B>
                              </TD>
                              <xsl:if test="$MarginReporting='true'">
                                 <TD style="background-color:#AAA">
                                    <B>Margin</B>
                                 </TD>
                              </xsl:if>
                           </xsl:otherwise>
                        </xsl:choose>

                        <TD style="background-color:#AAA">
                           <B>Pass Limits</B>
                        </TD>
                     </TR>

                     <!-- Show Report Summary-->
                     <xsl:apply-templates select="ComplianceReporter/TestResults" mode="ResultsSummary"/>
                  </TABLE>
                  <!-- End of Summary Section -->

                  <br/>
                  <br style="page-break-before:always"/>
                  <h2> Report Detail</h2>
                  <!-- Generate Detailed Report -->
                  <xsl:apply-templates select="ComplianceReporter/TestResults" mode="ResultsDetail"/>

               </xsl:otherwise>
            </xsl:choose>
         </BODY>
      </HTML>
   </xsl:template>
</xsl:stylesheet>
 
